local t = Def.ActorFrame {};

for idx,diff in pairs(Difficulty) do
	local sDifficulty = ToEnumShortString( diff );
	local tLocation = {
		Beginner	= 32*0.40,
		Easy 		= 32*1.46,
		Medium		= 32*2.52,
		Hard		= 32*3.58,
		Challenge	= 32*4.64,
		Edit 		= 32*5.70,
	};
	t[#t+1] = Def.ActorFrame {
		InitCommand=cmd(x,-70;y,-62.5);
		SetCommand=function(self)
			local c = self:GetChildren();
			local song = GAMESTATE:GetCurrentSong()
			local bHasStepsTypeAndDifficulty = false;
			local meter = "";
			if song then
				local st = GAMESTATE:GetCurrentStyle():GetStepsType()
				bHasStepsTypeAndDifficulty = song:HasStepsTypeAndDifficulty( st, diff );
				local steps = song:GetOneSteps( st, diff );
				if steps then
					meter = steps:GetMeter();
					append = ""
				end
			end
			c.Meter:settext( meter );
			self:playcommand( bHasStepsTypeAndDifficulty and "Show" or "Hide" );
		end;
		CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
		--
		Def.Quad{
		InitCommand=cmd(zoomto,30,30;x,-64-8+tLocation[sDifficulty];diffuse,color("0,0,0,0.5"));
		};
		LoadFont("StepsDisplay","Meter") .. {
			Name="Meter";
			ShowCommand=cmd(stoptweening;linear,0.1;diffuse,CustomDifficultyToColor( sDifficulty ));
			HideCommand=cmd(stoptweening;decelerate,0.05;diffuse,CustomDifficultyToDarkColor( sDifficulty ));
			InitCommand=cmd(x,-64-8+tLocation[sDifficulty];shadowlength,1;zoom,0.75;diffuse,CustomDifficultyToColor( sDifficulty ));
		};
	};
end
return t